VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   7755
   ClientLeft      =   2265
   ClientTop       =   1635
   ClientWidth     =   6105
   LinkTopic       =   "Form1"
   ScaleHeight     =   7755
   ScaleWidth      =   6105
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop AI Buffered Task"
      Height          =   375
      Left            =   720
      TabIndex        =   16
      Top             =   5520
      Width           =   2295
   End
   Begin VB.TextBox txtExtClk 
      Height          =   285
      Left            =   1800
      TabIndex        =   14
      Text            =   "1000"
      Top             =   2040
      Width           =   855
   End
   Begin VB.TextBox txtSampleNumber 
      Height          =   375
      Left            =   1800
      TabIndex        =   12
      Text            =   "10"
      Top             =   1440
      Width           =   615
   End
   Begin VB.CommandButton cmdToggle 
      Caption         =   "Toggle DO bit0 N times"
      Height          =   375
      Left            =   720
      TabIndex        =   10
      Top             =   4800
      Width           =   2295
   End
   Begin DlsrLib.DriverLINXSR SRDO 
      Left            =   4920
      Top             =   1440
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "OK"
      Height          =   495
      Left            =   4680
      TabIndex        =   9
      Top             =   5640
      Width           =   735
   End
   Begin VB.Frame Frame1 
      Caption         =   "Clock Source"
      Height          =   1095
      Left            =   720
      TabIndex        =   6
      Top             =   2760
      Width           =   1815
      Begin VB.OptionButton Option1 
         Caption         =   "Internal Clock"
         Height          =   255
         Left            =   240
         TabIndex        =   8
         Top             =   720
         Width           =   1455
      End
      Begin VB.OptionButton optExternal 
         Caption         =   "External Clock"
         Height          =   255
         Left            =   240
         TabIndex        =   7
         Top             =   360
         Value           =   -1  'True
         Width           =   1455
      End
   End
   Begin VB.ComboBox devNum 
      Height          =   315
      Left            =   2880
      TabIndex        =   4
      Text            =   "0"
      Top             =   720
      Width           =   615
   End
   Begin VB.ListBox List1 
      Height          =   2205
      Left            =   2880
      TabIndex        =   3
      Top             =   1320
      Width           =   1815
   End
   Begin VB.CommandButton cmdSample 
      Caption         =   "Arm AI Buffered Task"
      Enabled         =   0   'False
      Height          =   375
      Left            =   720
      TabIndex        =   1
      Top             =   4200
      Width           =   2295
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize"
      Height          =   375
      Left            =   480
      TabIndex        =   0
      Top             =   720
      Width           =   1935
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   4920
      Top             =   240
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   4920
      Top             =   840
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label7 
      Caption         =   "Step 2: if using the DO bit to simulate Ext Clk"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   3360
      TabIndex        =   19
      Top             =   4920
      Width           =   1935
   End
   Begin VB.Label Label6 
      Caption         =   "Step 1"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   3360
      TabIndex        =   18
      Top             =   4320
      Width           =   735
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H8000000E&
      Height          =   375
      Left            =   600
      TabIndex        =   17
      Top             =   6960
      Width           =   4095
   End
   Begin VB.Label Label5 
      Caption         =   "Estimated Ext CLK Rate (Hz)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   240
      TabIndex        =   15
      Top             =   2040
      Width           =   1335
   End
   Begin VB.Label Label4 
      Caption         =   "How Many Samples: "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   360
      TabIndex        =   13
      Top             =   1440
      Width           =   1215
   End
   Begin VB.Label Label3 
      Caption         =   "Connect DO bit 0 to Ext Trigger Line for external clocking (pin 23 to 25)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   600
      TabIndex        =   11
      Top             =   6120
      Width           =   3135
   End
   Begin VB.Label Label2 
      Caption         =   "Device Number: "
      Height          =   255
      Left            =   2880
      TabIndex        =   5
      Top             =   360
      Width           =   1335
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   300
      Left            =   600
      TabIndex        =   2
      Top             =   120
      Width           =   1455
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit ' require variable declaration
Dim SampleRate As Single
Dim BufferSize As Long
Dim AIData() As Single
'
'  tested in Win2K SP4 with KPCMCIA-850A04.0.0.2 driver revision
'  Program demonstrates internal or external clocking of Analog Input
'
'  For proper functioning of external clock, 0.0.1 or higher driver update
'  must be applied on top of the A04 driver!
'
'  A second SR object is used to simulate an external clock by toggling
'  a digital output bit on the kpcmcia card

Private Sub cmdExit_Click()
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End
End Sub

Private Sub cmdInit_Click()
' open the driver and initialize the hardware
With SR
.Req_DLL_name = "kpcaiao"  ' give driver name to avoid Open DriverLINX dialog
.Req_device = devNum.ListIndex
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
End With
' use of the LDD control is not required
If SR.Res_result = DL_NoErr Then
cmdSample.Enabled = True
cmdInit.Enabled = False
LDD.Req_DLL_name = SR.Req_DLL_name
LDD.Refresh
Form1.Caption = "Paced Analog Input with " & LDD.Dev_Model  'from the LDD, determine the model number
' load second OCX with same driver name since same physical board
With SRDO
.Req_DLL_name = SR.Req_DLL_name
.Req_device = SR.Req_device
End With
Else
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
End If
' the LDD control can inform your application
' about the features of the hardware
Form1.SetFocus
End Sub

Private Sub cmdSample_Click()
List1.Clear  ' clear the list box
BufferSize = CLng(txtSampleNumber.Text)
SetupAIPaced
'SR.Req_op_edit = True
'SR.Refresh
SR.Refresh  ' do it
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh

lblStatus.Caption = "AI task started...."

' enable the bit toggle button
'cmdToggle.Enabled = True
'cmdSample.Enabled = False
' see Private Sub SR_BufferFilled() for what happens next
End Sub

Private Sub cmdStop_Click()
With SR
.Req_op = DL_STOP
.Refresh
End With
lblStatus.Caption = "AI task stopped by request"
End Sub

Private Sub cmdToggle_Click()
' toggle the DO bit0 N times to simulate the external clock
'
' connect pin 23 to 25
With SRDO
' Request Group
.Req_op = DL_START
.Req_mode = DL_POLLED  ' no pacing clock involved
.Req_subsystem = DL_DO
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop automatically
.Evt_Tim_type = DL_NULLEVENT  ' no timing for Polled mode
' Select Group
.Sel_buf_N = 0                 ' no buffers used
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 1                ' one channel
.Sel_chan_start = 0            ' is is channel 0
End With

Dim i As Long
For i = 0 To BufferSize - 1
SRDO.Res_Sta_ioValue = 1
SRDO.Refresh
SRDO.Res_Sta_ioValue = 0
SRDO.Refresh
Next i
'Debug.Print SRDO.Message

'cmdSample.Enabled = True
'cmdToggle.Enabled = False


End Sub

Private Sub Form_Load()
' load devNum with legal values
Dim i As Integer
For i = 0 To 5
devNum.AddItem Str(i), i
Next i
' set it to first entry
devNum.ListIndex = 0

' set SampleRate equal to the default radio button, 10Hz
SampleRate = 10
End Sub

Private Sub Form_Terminate()
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End Sub

Sub SetupAIPaced()
With SR
' Request Group
.Req_op = DL_START
.Req_mode = DL_INTERRUPT  ' could be DL_DMA if board has DMA feature
.Req_subsystem = DL_AI
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop automatically
.Evt_Tim_type = DL_RATEEVENT ' timing will be used
.Evt_Tim_rateChannel = DL_DEFAULTTIMER  ' each board has default timing channel
If optExternal.Value = True Then
.Evt_Tim_rateClock = DL_EXTERNAL       ' external clock at pin 25 (trigger pin)
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / CSng(txtExtClk.Text)) ' estimated external clk rate
Else
.Evt_Tim_rateClock = DL_INTERNAL1       ' internal1 timebase
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / CSng(txtExtClk.Text)) ' requested internal clock rate
End If
.Evt_Tim_rateGate = DL_NOCONNECT   ' no gating
.Evt_Tim_rateMode = DL_RATEGEN     ' one sample for each tic of clock
.Evt_Tim_rateOutput = CT_Output_Default ' not used for RATEGEN

' Select Group
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 1                ' 1 means a start channel only
.Sel_chan_start = 0            ' start on channel 0
.Sel_chan_startGainCode = .DLGain2Code(-1) ' negative = bipolar, 1 = gain of 1

' allocate one buffer equal to number of channels for the data
.Sel_buf_N = 1                 ' one buffer used
.Sel_buf_samples = BufferSize   ' how many samples
' the buffer MUST be a multiple of how many channels are in the scan, e.g., 8, 16, etc.
.Sel_buf_notify = DL_NOTIFY  ' send buffer filled message
End With
End Sub


Private Sub SR_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)
Beep
' allocate array for the data and some other variables that will be needed
ReDim AIData(BufferSize) As Single  ' allocate local array for our buffer of data

Dim dummy As Single
Dim i As Integer
List1.Clear  ' clear the list box

' the BufferFilled message contains the bufIndex that is ready for conversion
dummy = SR.VBArrayBufferConvert(bufIndex, 0, BufferSize, AIData, DL_tSINGLE, 0, 0)
' display first 4 data points in our list
For i = 0 To 3
List1.AddItem "sample #: " & Str(i) & " : " & Str(Format(AIData(i), "##.##0"))
Next i
lblStatus.Caption = "AI task complete"
End Sub
